<?php
header('Content-Type: application/json; charset=utf-8');

// Include database connection file
require_once "database.php";

// Query to retrieve posts and user names
$sql = "SELECT p.*, u.*
        FROM post p
        JOIN users u ON p.post_user_id = u.id
        ORDER BY p.time DESC";

$result = mysqli_query($connection, $sql);

$data = array();

foreach ($result as $item) {
    $id = $item['id'];
    $post_user_id = $item['post_user_id'];
    $post = $item['post'];
    $time = $item['time'];
    $username = $item['name']; // Get the username from the joined result
    $profile_image_url = $item['profile_image_url'];  // Get the profile_image_url from the joined result

    $userInfo = [
        'id' => $id,
        'post_user_id' => $post_user_id,
        'post' => $post,
        'time' => $time,
        'name' => $username, // Include the username in the output
        'profile_image_url' => $profile_image_url   // Include the profile_image_url in the output
    ];

    array_push($data, $userInfo);
}

echo json_encode($data);




?>
