<?php
// Connect to the MySQL database
require_once "database.php";

// Escape user-provided data
$post_user_id = mysqli_real_escape_string($connection, $_GET['puid']);
$post = mysqli_real_escape_string($connection, $_GET['p']);

// Use prepared statements
$stmt = mysqli_prepare($connection, "INSERT INTO post (post_user_id, post, time) VALUES (?, ?, NOW() + INTERVAL 6 HOUR)");
mysqli_stmt_bind_param($stmt, "is", $post_user_id, $post);

// Execute the query and handle the result
if (mysqli_stmt_execute($stmt)) {
    echo "post";
} else {
    echo "Post failed: " . mysqli_error($connection);
}

mysqli_stmt_close($stmt);
mysqli_close($connection);
?>
